@extends('layouts.app')


@section('page-content')
    <div class="content container-fluid">

        <!-- Page Header -->
        <x-breadcrumb class="col">
            <x-slot name="title">{{ __('Estimates') }}</x-slot>
            <ul class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a>
                </li>
                <li class="breadcrumb-item active">
                    {{ __('Estimates') }}
                </li>
            </ul>
            <x-slot name="right">
                <div class="col-auto float-end ms-auto">
                    <div class="btn-group btn-group-sm" x-data="{
                        printContent: function(){
                            const originalContents = $('body').html();
                            var printContents = $('#estimateSection').html()
                            $('body').empty().html(printContents);
                            window.print();
                            $('body').html(originalContents);
                    }}">
                        <button class="btn btn-white" onclick='window.location.href="{{ route('estimates.index') }}"'>{{ __('Go Back') }}</button>
                        <button class="btn btn-white" @click="function(){
                            const doc = new jsPDF({compress: true});
                            doc.html(document.getElementById('estimateSection'),{
                                callback: function (doc) {
                                    let totalPages = doc.internal.getNumberOfPages()
                                    {{-- //temporal solution for the blanks pages generated by jspdf --}}
                                    for (var i = 2; i <= totalPages; i++) {
                                        doc.setPage(i);
                                        doc.deletePage(i);
                                        i--;
                                        totalPages--;
                                    }
                                    doc.save('{{ $estimate->est_id }}.pdf');
                                },
                                html2canvas: {
                                    useCORS: true,
                                    allowTaint: true,
                                    letterRendering: true,
                                    scale: 0.27
                                },
                                autoPaging: 'text',
                                jsPDF: doc,
                            })
                        }">{{ __('PDF') }}</button>
                        <button class="btn btn-white" @click="printContent"><i class="fa-solid fa-print fa-lg"></i> {{ __('Print') }}</button>
                    </div>
                </div>
            </x-slot>
        </x-breadcrumb>
        <!-- /Page Header -->

        <div class="row" id="estimateSection">
            <div class="col-md-12">
                <x-sales::estimate-card :estimate="$estimate" />
            </div>
        </div>
    </div>
@endsection


@push('page-scripts')
@endpush